IF OBJECT_ID('P_CARGA_PRODUTOS_ECOMMERCE') IS NOT NULL
BEGIN
	DROP PROCEDURE P_CARGA_PRODUTOS_ECOMMERCE
END
GO

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20230829
'Job.................:  
'Nome................: P_CARGA_PRODUTOS_ECOMMERCE 
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 29/08/2023
'Versionado por......: Marcos barros
'Alterado por........: Juan Andres Mello
'Criado por..........: 
'=======================================================================================
FARMAGOI-42774

-- exec P_CARGA_PRODUTOS_ECOMMERCE
*/


CREATE PROCEDURE [dbo].[P_CARGA_PRODUTOS_ECOMMERCE] (
	@CD_FILIAL_PROC NVARCHAR(1500)
	,@TP_EVENTO INT = 0
	,@CD_PROD_ENV INT = 0
	)
	--EXEC P_CARGA_PRODUTOS_ECOMMERCE '',0
	WITH ENCRYPTION
AS
--@TP_EVENTO
--0 - TUDO (PRODUTOS,ESTOQUE,PREOS) CARGA FULL
--1 - CADASTRO DE PRODUTOS ALTERADOS NO DIA
--2 - PRECOS ALTERADOS NO DIA
--3 - ESTOQUES ALTERADOS NO DIA
--4 - PRODUTO,ESTOQUE E PREOS ALTERADOS NO DIA
--5  - ESTOQUE ESPECIFICO
--6 -  PREO ESPECIFICO
SET NOCOUNT ON;

IF OBJECT_ID('TEMPDB.DBO.#RS_PROD') IS NOT NULL
BEGIN
	DROP TABLE #RS_PROD
END

CREATE TABLE #RS_PROD (
	CD_EMP INT
	,CD_PROD INT
	,PRIMARY KEY (
		CD_EMP
		,CD_PROD
		)
	)

IF OBJECT_ID('TEMPDB.DBO.#RS_PROD_PRECO') IS NOT NULL
BEGIN
	DROP TABLE #RS_PROD_PRECO
END

CREATE TABLE #RS_PROD_PRECO (
	CD_EMP INT
	,CD_FILIAL INT
	,CD_PROD INT PRIMARY KEY (
		CD_EMP
		,CD_FILIAL
		,CD_PROD
		)
	)

IF OBJECT_ID('TEMPDB.DBO.#RS_PROD_ESTOQUE') IS NOT NULL
BEGIN
	DROP TABLE #RS_PROD_ESTOQUE
END

CREATE TABLE #RS_PROD_ESTOQUE (
	CD_EMP INT
	,CD_FILIAL INT
	,CD_PROD INT PRIMARY KEY (
		CD_EMP
		,CD_FILIAL
		,CD_PROD
		)
	)

IF OBJECT_ID('TEMPDB.DBO.#RS_FILIAIS_ECOMMERCE') IS NOT NULL
BEGIN
	DROP TABLE #RS_FILIAIS_ECOMMERCE
END

CREATE TABLE #RS_FILIAIS_ECOMMERCE (
	CD_EMP INT
	,CD_FILIAL INT
	,PRIMARY KEY (
		CD_EMP
		,CD_FILIAL
		)
	)

IF @CD_FILIAL_PROC <> ''
BEGIN
	INSERT INTO #RS_FILIAIS_ECOMMERCE
	SELECT CD_EMP
		,CD_FILIAL
	FROM PRC_FILIAL
	WHERE CD_EMP = 1
		AND CD_FILIAL IN (
			SELECT ID
			FROM UFD_PRM_IN_STRING(@CD_FILIAL_PROC)
			);
END

IF @CD_FILIAL_PROC = ''
BEGIN
	INSERT INTO #RS_FILIAIS_ECOMMERCE
	SELECT CD_EMP
		,CD_FILIAL
	FROM PRC_FILIAL
	WHERE CD_EMP = 1
		AND CD_FILIAL IN (
			SELECT CD_FILIAL
			FROM prc_filial_config
			WHERE cd_chave LIKE 'FILIAL_ECOMMERCE_FAST_LINX_IO'
				AND valor = '1'
			);
END

DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_PROD INT

IF @TP_EVENTO = 0 --0 - TUDO (PRODUTOS,ESTOQUE,PREOS) CARGA FULL
BEGIN
	INSERT INTO #RS_PROD
	SELECT CD_EMP
		,CD_PROD
	FROM EST_PROD
	WHERE CD_EMP = 1
		AND ISNULL(FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0;

	INSERT INTO #RS_PROD_PRECO
	SELECT EST_PROD_PRECO.CD_EMP
		,EST_PROD_PRECO.CD_FILIAL
		,EST_PROD_PRECO.CD_PROD
	FROM EST_PROD
	INNER JOIN EST_PROD_PRECO ON EST_PROD.CD_EMP = EST_PROD_PRECO.CD_EMP
		AND EST_PROD.CD_PROD = EST_PROD_PRECO.CD_PROD
	WHERE EST_PROD_PRECO.cd_emp = 1
		AND EST_PROD_PRECO.cd_filial IN (
			SELECT isnull(valor, 0)
			FROM prc_emp_config
			WHERE cd_chave LIKE 'FILIAL_ESPELHO_PRECO_ECOMMERCE'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0;

	INSERT INTO #RS_PROD_ESTOQUE
	SELECT EST_PROD_CPL.CD_EMP
		,EST_PROD_CPL.CD_FILIAL
		,EST_PROD_CPL.CD_PROD
	FROM est_prod_cpl
	INNER JOIN est_prod ON est_prod_cpl.cd_emp = est_prod.cd_emp
		AND est_prod_cpl.cd_prod = est_prod.cd_prod
	INNER JOIN #RS_FILIAIS_ECOMMERCE ON EST_PROD_CPL.CD_EMP = #RS_FILIAIS_ECOMMERCE.CD_EMP
		AND EST_PROD_CPL.CD_FILIAL = #RS_FILIAIS_ECOMMERCE.CD_FILIAL
	WHERE est_prod_cpl.cd_emp = 1
		AND est_prod_cpl.cd_filial IN (
			SELECT cd_filial
			FROM prc_filial_config
			WHERE cd_chave LIKE 'FILIAL_ECOMMERCE_FAST_LINX_IO'
				AND valor = '1'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0;
END

IF @TP_EVENTO = 1 --1 - CADASTRO DE PRODUTOS ALTERADOS NO DIA
BEGIN
	INSERT INTO #RS_PROD
	SELECT CD_EMP
		,CD_PROD
	FROM EST_PROD
	WHERE CD_EMP = 1
		AND STS_PROD = 0
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND CONVERT(VARCHAR(10), DT_CAD, 112) = convert(VARCHAR(10), getdate(), 112)
	
	UNION
	
	SELECT CD_EMP
		,CD_PROD
	FROM EST_PROD
	WHERE CD_EMP = 1
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND CONVERT(VARCHAR(10), DT_ULT_ATU, 112) = convert(VARCHAR(10), getdate(), 112);
END

IF @TP_EVENTO = 2 --2 - PRECOS ALTERADOS NO DIA
BEGIN
	INSERT INTO #RS_PROD_PRECO
	SELECT EST_PROD_PRECO.CD_EMP
		,EST_PROD_PRECO.CD_FILIAL
		,EST_PROD_PRECO.CD_PROD
	FROM EST_PROD
	INNER JOIN EST_PROD_PRECO ON EST_PROD.CD_EMP = EST_PROD_PRECO.CD_EMP
		AND EST_PROD.CD_PROD = EST_PROD_PRECO.CD_PROD
	WHERE EST_PROD_PRECO.cd_emp = 1
		AND EST_PROD_PRECO.cd_filial IN (
			SELECT isnull(valor, 0)
			FROM prc_emp_config
			WHERE cd_chave LIKE 'FILIAL_ESPELHO_PRECO_ECOMMERCE'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND CONVERT(VARCHAR(10), EST_PROD_PRECO.DT_CAD, 112) = convert(VARCHAR(10), getdate(), 112);
END

IF @TP_EVENTO = 3 --3 - ESTOQUES ALTERADOS NO DIA
BEGIN
	INSERT INTO #RS_PROD_ESTOQUE
	SELECT EST_PROD_CPL.CD_EMP
		,EST_PROD_CPL.CD_FILIAL
		,EST_PROD_CPL.CD_PROD
	FROM est_prod_cpl
	INNER JOIN est_prod ON est_prod_cpl.cd_emp = est_prod.cd_emp
		AND est_prod_cpl.cd_prod = est_prod.cd_prod
	INNER JOIN #RS_FILIAIS_ECOMMERCE ON EST_PROD_CPL.CD_EMP = #RS_FILIAIS_ECOMMERCE.CD_EMP
		AND EST_PROD_CPL.CD_FILIAL = #RS_FILIAIS_ECOMMERCE.CD_FILIAL
	WHERE est_prod_cpl.cd_emp = 1
		AND est_prod_cpl.cd_filial IN (
			SELECT cd_filial
			FROM prc_filial_config
			WHERE cd_chave LIKE 'FILIAL_ECOMMERCE_FAST_LINX_IO'
				AND valor = '1'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND NOT EXISTS (
			SELECT CODIGO_PRODUTO
			FROM INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE
			WHERE EST_PROD_CPL.CD_FILIAL = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_FILIAL
				AND EST_PROD_CPL.CD_PROD = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_PRODUTO
			)
	
	UNION
	
	SELECT EST_PROD_CPL.CD_EMP
		,EST_PROD_CPL.CD_FILIAL
		,EST_PROD_CPL.CD_PROD
	FROM est_prod_cpl
	INNER JOIN est_prod ON est_prod_cpl.cd_emp = est_prod.cd_emp
		AND est_prod_cpl.cd_prod = est_prod.cd_prod
	INNER JOIN #RS_FILIAIS_ECOMMERCE ON EST_PROD_CPL.CD_EMP = #RS_FILIAIS_ECOMMERCE.CD_EMP
		AND EST_PROD_CPL.CD_FILIAL = #RS_FILIAIS_ECOMMERCE.CD_FILIAL
	INNER JOIN INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE ON EST_PROD_CPL.CD_FILIAL = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_FILIAL
		AND EST_PROD_CPL.CD_PROD = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_PRODUTO
	WHERE est_prod_cpl.cd_emp = 1
		AND est_prod_cpl.cd_filial IN (
			SELECT cd_filial
			FROM prc_filial_config
			WHERE cd_chave LIKE 'FILIAL_ECOMMERCE_FAST_LINX_IO'
				AND valor = '1'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND (EST_PROD_CPL.QT_EST + EST_PROD_CPL.QT_EST_DE_TERC) <> INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.QUANTIDADE;
END

IF @TP_EVENTO = 4
BEGIN
	INSERT INTO #RS_PROD
	SELECT CD_EMP
		,CD_PROD
	FROM EST_PROD
	WHERE CD_EMP = 1
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND CONVERT(VARCHAR(10), DT_CAD, 112) = convert(VARCHAR(10), getdate(), 112)
	
	UNION
	
	SELECT CD_EMP
		,CD_PROD
	FROM EST_PROD
	WHERE CD_EMP = 1
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND CONVERT(VARCHAR(10), DT_ULT_ATU, 112) = convert(VARCHAR(10), getdate(), 112);

	INSERT INTO #RS_PROD_PRECO
	SELECT EST_PROD_PRECO.CD_EMP
		,EST_PROD_PRECO.CD_FILIAL
		,EST_PROD_PRECO.CD_PROD
	FROM EST_PROD
	INNER JOIN EST_PROD_PRECO ON EST_PROD.CD_EMP = EST_PROD_PRECO.CD_EMP
		AND EST_PROD.CD_PROD = EST_PROD_PRECO.CD_PROD
	WHERE EST_PROD_PRECO.cd_emp = 1
		AND EST_PROD_PRECO.cd_filial IN (
			SELECT isnull(valor, 0)
			FROM prc_emp_config
			WHERE cd_chave LIKE 'FILIAL_ESPELHO_PRECO_ECOMMERCE'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND CONVERT(VARCHAR(10), EST_PROD_PRECO.DT_CAD, 112) = convert(VARCHAR(10), getdate(), 112);

	INSERT INTO #RS_PROD_ESTOQUE
	SELECT EST_PROD_CPL.CD_EMP
		,EST_PROD_CPL.CD_FILIAL
		,EST_PROD_CPL.CD_PROD
	FROM est_prod_cpl
	INNER JOIN est_prod ON est_prod_cpl.cd_emp = est_prod.cd_emp
		AND est_prod_cpl.cd_prod = est_prod.cd_prod
	INNER JOIN #RS_FILIAIS_ECOMMERCE ON EST_PROD_CPL.CD_EMP = #RS_FILIAIS_ECOMMERCE.CD_EMP
		AND EST_PROD_CPL.CD_FILIAL = #RS_FILIAIS_ECOMMERCE.CD_FILIAL
	WHERE est_prod_cpl.cd_emp = 1
		AND est_prod_cpl.cd_filial IN (
			SELECT cd_filial
			FROM prc_filial_config
			WHERE cd_chave LIKE 'FILIAL_ECOMMERCE_FAST_LINX_IO'
				AND valor = '1'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND NOT EXISTS (
			SELECT CODIGO_PRODUTO
			FROM INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE
			WHERE EST_PROD_CPL.CD_FILIAL = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_FILIAL
				AND EST_PROD_CPL.CD_PROD = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_PRODUTO
			)
	
	UNION
	
	SELECT EST_PROD_CPL.CD_EMP
		,EST_PROD_CPL.CD_FILIAL
		,EST_PROD_CPL.CD_PROD
	FROM est_prod_cpl
	INNER JOIN est_prod ON est_prod_cpl.cd_emp = est_prod.cd_emp
		AND est_prod_cpl.cd_prod = est_prod.cd_prod
	INNER JOIN #RS_FILIAIS_ECOMMERCE ON EST_PROD_CPL.CD_EMP = #RS_FILIAIS_ECOMMERCE.CD_EMP
		AND EST_PROD_CPL.CD_FILIAL = #RS_FILIAIS_ECOMMERCE.CD_FILIAL
	INNER JOIN INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE ON EST_PROD_CPL.CD_FILIAL = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_FILIAL
		AND EST_PROD_CPL.CD_PROD = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_PRODUTO
	WHERE est_prod_cpl.cd_emp = 1
		AND est_prod_cpl.cd_filial IN (
			SELECT cd_filial
			FROM prc_filial_config
			WHERE cd_chave LIKE 'FILIAL_ECOMMERCE_FAST_LINX_IO'
				AND valor = '1'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND (EST_PROD_CPL.QT_EST + EST_PROD_CPL.QT_EST_DE_TERC) <> INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.QUANTIDADE;
END

IF @TP_EVENTO = 5 --5  - ESTOQUE ESPECIFICO
BEGIN
	INSERT INTO #RS_PROD_ESTOQUE
	SELECT EST_PROD_CPL.CD_EMP
		,EST_PROD_CPL.CD_FILIAL
		,EST_PROD_CPL.CD_PROD
	FROM est_prod_cpl
	INNER JOIN est_prod ON est_prod_cpl.cd_emp = est_prod.cd_emp
		AND est_prod_cpl.cd_prod = est_prod.cd_prod
	INNER JOIN #RS_FILIAIS_ECOMMERCE ON EST_PROD_CPL.CD_EMP = #RS_FILIAIS_ECOMMERCE.CD_EMP
		AND EST_PROD_CPL.CD_FILIAL = #RS_FILIAIS_ECOMMERCE.CD_FILIAL
	INNER JOIN INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE ON EST_PROD_CPL.CD_FILIAL = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_FILIAL
		AND EST_PROD_CPL.CD_PROD = INTEGRADOR_LINX_ECOMMERCE_ULTIMO_ESTADO_ESTOQUE.CODIGO_PRODUTO
	WHERE est_prod_cpl.cd_emp = 1
		AND est_prod_cpl.cd_filial IN (
			SELECT cd_filial
			FROM prc_filial_config
			WHERE cd_chave LIKE 'FILIAL_ECOMMERCE_FAST_LINX_IO'
				AND valor = '1'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND EST_PROD_CPL.CD_PROD = @CD_PROD_ENV
END

IF @TP_EVENTO = 6
BEGIN
	INSERT INTO #RS_PROD_PRECO
	SELECT EST_PROD_PRECO.CD_EMP
		,EST_PROD_PRECO.CD_FILIAL
		,EST_PROD_PRECO.CD_PROD
	FROM EST_PROD
	INNER JOIN EST_PROD_PRECO ON EST_PROD.CD_EMP = EST_PROD_PRECO.CD_EMP
		AND EST_PROD.CD_PROD = EST_PROD_PRECO.CD_PROD
	WHERE EST_PROD_PRECO.cd_emp = 1
		AND EST_PROD_PRECO.cd_filial IN (
			SELECT isnull(valor, 0)
			FROM prc_emp_config
			WHERE cd_chave LIKE 'FILIAL_ESPELHO_PRECO_ECOMMERCE'
			)
		AND ISNULL(EST_PROD.FLAG_NAO_ENVIA_ECOMMERCE, 0) = 0
		AND EST_PROD_PRECO.CD_PROD = @CD_PROD_ENV;
END

DECLARE ECOMMERCE_CARGA_PROD CURSOR FAST_FORWARD
FOR
SELECT DISTINCT CD_EMP
	,CD_PROD
FROM #RS_PROD

OPEN ECOMMERCE_CARGA_PROD

FETCH NEXT
FROM ECOMMERCE_CARGA_PROD
INTO @CD_EMP
	,@CD_PROD

WHILE @@FETCH_STATUS = 0
BEGIN
	PRINT 'Enviando Produtos ' + convert(VARCHAR, @CD_PROD) + ' - ' + CONVERT(VARCHAR, GETDATE(), 108);

	UPDATE EST_PROD
	SET CD_EMP = 1
	WHERE CD_EMP = @CD_EMP
		AND CD_PROD = @CD_PROD

	--Proximo registro
	FETCH NEXT
	FROM ECOMMERCE_CARGA_PROD
	INTO @CD_EMP
		,@CD_PROD
END

CLOSE ECOMMERCE_CARGA_PROD;

DEALLOCATE ECOMMERCE_CARGA_PROD;

DROP TABLE #RS_PROD;

DECLARE ECOMMERCE_CARGA_PRECO CURSOR FAST_FORWARD
FOR
SELECT DISTINCT CD_EMP
	,CD_FILIAL
	,CD_PROD
FROM #RS_PROD_PRECO

OPEN ECOMMERCE_CARGA_PRECO

FETCH NEXT
FROM ECOMMERCE_CARGA_PRECO
INTO @CD_EMP
	,@CD_FILIAL
	,@CD_PROD

WHILE @@FETCH_STATUS = 0
BEGIN
	PRINT 'Enviando Preo ' + convert(VARCHAR, @CD_PROD) + ' - FILIAL  ' + convert(VARCHAR, @CD_FILIAL) + '  HORA  ' + CONVERT(VARCHAR, GETDATE(), 108);

	UPDATE EST_PROD_PRECO
	SET CD_EMP = 1
	WHERE CD_EMP = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD = @CD_PROD

	--Proximo registro
	FETCH NEXT
	FROM ECOMMERCE_CARGA_PRECO
	INTO @CD_EMP
		,@CD_FILIAL
		,@CD_PROD
END

CLOSE ECOMMERCE_CARGA_PRECO;

DEALLOCATE ECOMMERCE_CARGA_PRECO;

DROP TABLE #RS_PROD_PRECO;

DECLARE ECOMMERCE_CARGA_ESTOQUE CURSOR FAST_FORWARD
FOR
SELECT DISTINCT CD_EMP
	,CD_FILIAL
	,CD_PROD
FROM #RS_PROD_ESTOQUE

OPEN ECOMMERCE_CARGA_ESTOQUE

FETCH NEXT
FROM ECOMMERCE_CARGA_ESTOQUE
INTO @CD_EMP
	,@CD_FILIAL
	,@CD_PROD

WHILE @@FETCH_STATUS = 0
BEGIN
	PRINT 'Enviando Estoque ' + convert(VARCHAR, @CD_PROD) + ' - FILIAL  ' + convert(VARCHAR, @CD_FILIAL) + '  HORA  ' + CONVERT(VARCHAR, GETDATE(), 108);

	UPDATE EST_PROD_CPL
	SET CD_EMP = 1
	WHERE CD_EMP = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD = @CD_PROD

	--Proximo registro
	FETCH NEXT
	FROM ECOMMERCE_CARGA_ESTOQUE
	INTO @CD_EMP
		,@CD_FILIAL
		,@CD_PROD
END

CLOSE ECOMMERCE_CARGA_ESTOQUE;

DEALLOCATE ECOMMERCE_CARGA_ESTOQUE;

DROP TABLE #RS_PROD_ESTOQUE;
